--ALTER TABLE PDV_CONSLD_ERROS DROP COLUMN MSG_ID
IF OBJECT_ID('PDV_CONSLD_ERROS') IS NULL
BEGIN
--DROP TABLE PDV_CONSLD_ERROS
CREATE TABLE PDV_CONSLD_ERROS (
	ID			BIGINT	IDENTITY(1,1) PRIMARY KEY,
	CD_EMP		INT		NOT NULL,
	CD_FILIAL	INT		NOT NULL,
	TP_CUPOM	INT		NOT NULL,-- 0 = CUPOM_FISCAL, 1 = CUPOM_NAO_FISCAL, 3 = REDUCAO_Z
	CD_CX		INT		NOT NULL,
	DT_MOV		DATETIME		NOT NULL,
	NR_CUPOM 	INT				NOT NULL,
	VLR_CUPOM	MONEY			NOT NULL,
	MSG_ERRO	NVARCHAR(1000)	NOT NULL,
	MSG_ID		INT				NULL,
	DT_CAD		DATETIME		NULL DEFAULT GETDATE()
)

CREATE NONCLUSTERED INDEX IX_PDV_CONSLD_ERROS_DT_MOV
ON [dbo].[PDV_CONSLD_ERROS] ([DT_MOV])
INCLUDE ([ID],[CD_EMP],[CD_FILIAL],[TP_CUPOM],[CD_CX],[NR_CUPOM],[VLR_CUPOM],[MSG_ERRO],[DT_CAD],[MSG_ID])

END
ELSE
BEGIN
	IF COL_LENGTH('PDV_CONSLD_ERROS','MSG_ID') IS NULL
	BEGIN
		ALTER TABLE PDV_CONSLD_ERROS ADD MSG_ID INT NULL
	END
	IF COL_LENGTH('PDV_CONSLD_ERROS','DT_CAD') IS NULL
	BEGIN
		ALTER TABLE PDV_CONSLD_ERROS ADD DT_CAD DATETIME NULL DEFAULT GETDATE()
	END
END
